(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12778,        513]*)
(*NotebookOutlinePosition[     13656,        543]*)
(*  CellTagsIndexPosition[     13612,        539]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Repeated Roots-Example 1"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["The coefficient matrix A"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
(A={{2, 1, 0, 0, 0, 0}, {0, 2, 1, 0, 0, 0}, 
\t{0, 0, 2, 0, 0, 0}, {0, 0, 0, 2, 0, 0}, 
  \t{0, 0, 0, 0, 2, 1}, {0, 0, 0, 0, 0, 2}})//MatrixForm\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"2", "1", "0", "0", "0", "0"},
            {"0", "2", "1", "0", "0", "0"},
            {"0", "0", "2", "0", "0", "0"},
            {"0", "0", "0", "2", "0", "0"},
            {"0", "0", "0", "0", "2", "1"},
            {"0", "0", "0", "0", "0", "2"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Size=Length[A]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(6\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A-r*I"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["(mat[r_]=A-r*IdentityMatrix[Length[A]])//MatrixForm", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(2 - r\), "1", "0", "0", "0", "0"},
            {"0", \(2 - r\), "1", "0", "0", "0"},
            {"0", "0", \(2 - r\), "0", "0", "0"},
            {"0", "0", "0", \(2 - r\), "0", "0"},
            {"0", "0", "0", "0", \(2 - r\), "1"},
            {"0", "0", "0", "0", "0", \(2 - r\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Characteristic Polynomial"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["CharPoly=Factor[Det[mat[r]]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\((\(-2\) + r)\)\^6\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Characteristic Roots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["roots=Sort[r/.Solve[CharPoly==0,r]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({2, 2, 2, 2, 2, 2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["RootMultiplicities=RunEncode[roots]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{2, 6}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["{thisRoot,thisMultiplicity}=First[RootMultiplicities]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({2, 6}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Search for characteristic vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["MPwr=M=mat[thisRoot]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, 1, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0}, {0, 0, 0, 
        0, 0, 0}, {0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["NS=NullSpace[M]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, 0, 0, 0, 1, 0}, {0, 0, 0, 1, 0, 0}, {1, 0, 0, 0, 0, 
        0}}\)], "Output"]
}, Closed]],

Cell[TextData[
"We have now found some characteristic vectors.  Check the deficiency of the \
matrix."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Deficiency=thisMultiplicity-Length[NS]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(3\)], "Output"]
}, Closed]],

Cell[TextData[
"We must find 3 more characteristic vectors associated with the \
characteristic value 2."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Search for more characteristic vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Define 3 vectors of unknowns."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["AllKs=Table[k[i],{i,Size*Deficiency}]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[1], k[2], k[3], k[4], k[5], k[6], k[7], k[8], k[9], k[10], k[11], 
      k[12], k[13], k[14], k[15], k[16], k[17], k[18]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["CapK[0]=Take[AllKs,{1,Size}]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[1], k[2], k[3], k[4], k[5], k[6]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["CapK[1]=Take[AllKs,{Size+1,2*Size}]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[7], k[8], k[9], k[10], k[11], k[12]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["CapK[2]=Take[AllKs,{2*Size+1,3*Size}]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[13], k[14], k[15], k[16], k[17], k[18]}\)], "Output"]
}, Closed]],

Cell[TextData[
"Solve a system of equations in 18 unknowns to get characteristic vectors."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
SolveForK=Solve[{M.CapK[2]==0*CapK[2],M.CapK[1]==CapK[2]
\t\t\t,M.CapK[0]==CapK[1]},AllKs]\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message"],

Cell[BoxData[
    \({{k[2] \[Rule] k[7], k[3] \[Rule] k[13], k[6] \[Rule] k[11], 
        k[8] \[Rule] k[13], k[9] \[Rule] 0, k[10] \[Rule] 0, k[12] \[Rule] 0, 
        k[14] \[Rule] 0, k[15] \[Rule] 0, k[16] \[Rule] 0, k[17] \[Rule] 0, 
        k[18] \[Rule] 0}}\)], "Output"]
}, Closed]],

Cell[TextData["We obtain the following 3 vectors:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["KS[0]=CapK[0]/.SolveForK[[1]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[1], k[7], k[13], k[4], k[5], k[11]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["KS[1]=CapK[1]/.SolveForK[[1]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[7], k[13], 0, 0, k[11], 0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["KS[2]=CapK[2]/.SolveForK[[1]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[13], 0, 0, 0, 0, 0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Sub0=Map[Apply[Rule,#]&,
\tTranspose[{AllKs,0*AllKs}]]\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[1] \[Rule] 0, k[2] \[Rule] 0, k[3] \[Rule] 0, k[4] \[Rule] 0, 
      k[5] \[Rule] 0, k[6] \[Rule] 0, k[7] \[Rule] 0, k[8] \[Rule] 0, 
      k[9] \[Rule] 0, k[10] \[Rule] 0, k[11] \[Rule] 0, k[12] \[Rule] 0, 
      k[13] \[Rule] 0, k[14] \[Rule] 0, k[15] \[Rule] 0, k[16] \[Rule] 0, 
      k[17] \[Rule] 0, k[18] \[Rule] 0}\)], "Output"]
}, Closed]],

Cell[TextData[
"Now, find the characteristic vectors by using different values of k[i]."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
y1[x_]=(KS[0]+KS[1]*x+KS[2]*x^2/2)Exp[thisRoot*x]/.
\t\tk[1]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(2\ x\), 0, 0, 0, 0, 0}\)], "Output"]
}, Closed]],

Cell[TextData["y1 is a vector that we have already found."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
y2[x_]=(KS[0]+KS[1]*x+KS[2]*x^2/2)Exp[thisRoot*x]/.
\t\tk[7]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(2\ x\)\ x, \[ExponentialE]\^\(2\ x\), 0, 0, 0, 
      0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
y3[x_]=(KS[0]+KS[1]*x+KS[2]*x^2/2)Exp[thisRoot*x]/.
\t\tk[4]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0, 0, \[ExponentialE]\^\(2\ x\), 0, 0}\)], "Output"]
}, Closed]],

Cell[TextData["y3 is a vector that we have already found."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
y4[x_]=(KS[0]+KS[1]*x+KS[2]*x^2/2)Exp[thisRoot*x]/.
\t\tk[5]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0, 0, 0, \[ExponentialE]\^\(2\ x\), 0}\)], "Output"]
}, Closed]],

Cell[TextData["y4 is a vector that we have already found."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
y5[x_]=(KS[0]+KS[1]*x+KS[2]*x^2/2)Exp[thisRoot*x]/.
\t\tk[11]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0, 0, 
      0, \[ExponentialE]\^\(2\ x\)\ x, \[ExponentialE]\^\(2\ x\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
y6[x_]=(KS[0]+KS[1]*x+KS[2]*x^2/2)Exp[thisRoot*x]/.
\t\tk[13]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1\/2\ \[ExponentialE]\^\(2\ x\)\ x\^2, \[ExponentialE]\^\(2\ x\)\ x, \
\[ExponentialE]\^\(2\ x\), 0, 0, 0}\)], "Output"]
}, Closed]],

Cell[TextData[
"Finally, we have found all 6 characteristic vectors associated with the \
characteristic value 2."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Form the fundamental matrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
(W[x_]=Transpose[{y1[x],y2[x],y3[x],y4[x],y5[x],y6[x]}])//\
MatrixForm\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\[ExponentialE]\^\(2\ x\)\), \(\[ExponentialE]\^\(2\ x\)\ x\), 
              "0", "0", "0", \(1\/2\ \[ExponentialE]\^\(2\ x\)\ x\^2\)},
            {"0", \(\[ExponentialE]\^\(2\ x\)\), "0", "0", 
              "0", \(\[ExponentialE]\^\(2\ x\)\ x\)},
            {"0", "0", "0", "0", "0", \(\[ExponentialE]\^\(2\ x\)\)},
            {"0", "0", \(\[ExponentialE]\^\(2\ x\)\), "0", "0", "0"},
            {"0", "0", 
              "0", \(\[ExponentialE]\^\(2\ x\)\), \(\[ExponentialE]\^\(2\ x\)\
\ x\), "0"},
            {"0", "0", "0", "0", \(\[ExponentialE]\^\(2\ x\)\), "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check the fundamental matrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["W'[x]==A.W[x]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Implementation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["\<\
Attributes[times]={Flat};
times[{a_,m_},{a_,n_}]:=times[{a,m+n}]
RunEncode[x_List]:=List@@times@@({#,1}&/@ x)\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(times\)\" is similar to \
existing symbol \"\!\(Times\)\"."\)], "Message"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{550, 510},
WindowMargins->{{20, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 102, 2, 65, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1903, 59, 101, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2029, 65, 196, 5, 57, "Input"],
Cell[2228, 72, 443, 11, 117, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2708, 88, 58, 1, 27, "Input"],
Cell[2769, 91, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[2853, 98, 83, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2961, 104, 95, 1, 27, "Input"],
Cell[3059, 107, 479, 11, 117, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3587, 124, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3719, 130, 72, 1, 27, "Input"],
Cell[3794, 133, 53, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3896, 140, 102, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4023, 146, 79, 1, 27, "Input"],
Cell[4105, 149, 52, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4194, 155, 79, 1, 27, "Input"],
Cell[4276, 158, 42, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4355, 164, 97, 1, 27, "Input"],
Cell[4455, 167, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4544, 174, 110, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4679, 180, 64, 1, 27, "Input"],
Cell[4746, 183, 163, 2, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4946, 190, 59, 1, 27, "Input"],
Cell[5008, 193, 103, 2, 27, "Output"]
}, Closed]],
Cell[5126, 198, 160, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5311, 206, 82, 1, 27, "Input"],
Cell[5396, 209, 35, 1, 27, "Output"]
}, Closed]],
Cell[5446, 213, 163, 4, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[5646, 222, 115, 2, 36, "Section",
  Evaluatable->False],
Cell[5764, 226, 103, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5892, 232, 81, 1, 27, "Input"],
Cell[5976, 235, 158, 2, 43, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6171, 242, 72, 1, 27, "Input"],
Cell[6246, 245, 70, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6353, 251, 79, 1, 27, "Input"],
Cell[6435, 254, 73, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6545, 260, 81, 1, 27, "Input"],
Cell[6629, 263, 76, 1, 27, "Output"]
}, Closed]],
Cell[6720, 267, 151, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6896, 275, 142, 4, 42, "Input"],
Cell[7041, 281, 138, 3, 35, "Message"],
Cell[7182, 286, 277, 4, 59, "Output"]
}, Closed]],
Cell[7474, 293, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7607, 299, 73, 1, 27, "Input"],
Cell[7683, 302, 72, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7792, 308, 73, 1, 27, "Input"],
Cell[7868, 311, 63, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7968, 317, 73, 1, 27, "Input"],
Cell[8044, 320, 56, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8137, 326, 106, 4, 42, "Input"],
Cell[8246, 332, 359, 5, 59, "Output"]
}, Closed]],
Cell[8620, 340, 149, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8794, 348, 121, 4, 42, "Input"],
Cell[8918, 354, 76, 1, 29, "Output"]
}, Closed]],
Cell[9009, 358, 116, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9150, 364, 121, 4, 42, "Input"],
Cell[9274, 370, 110, 2, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9421, 377, 121, 4, 42, "Input"],
Cell[9545, 383, 76, 1, 29, "Output"]
}, Closed]],
Cell[9636, 387, 116, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9777, 393, 121, 4, 42, "Input"],
Cell[9901, 399, 76, 1, 29, "Output"]
}, Closed]],
Cell[9992, 403, 116, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10133, 409, 122, 4, 42, "Input"],
Cell[10258, 415, 110, 2, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10405, 422, 122, 4, 42, "Input"],
Cell[10530, 428, 141, 2, 42, "Output"]
}, Closed]],
Cell[10686, 433, 172, 4, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10895, 442, 104, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11024, 448, 122, 4, 42, "Input"],
Cell[11149, 454, 771, 15, 141, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11969, 475, 105, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12099, 481, 57, 1, 27, "Input"],
Cell[12159, 484, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12246, 491, 92, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12363, 497, 189, 6, 57, "Input",
  InitializationCell->True],
Cell[12555, 505, 183, 3, 49, "Message"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

alse],
Cell[6543, 236, 103, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6669, 240, 91, 1, 70, "Input"],
Cell[6763, 243, 354, 13, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7149, 258, 82, 1, 70, "Input"],
Cell[7234, 261, 176, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7442, 270, 89, 1, 70, "Input"],
Cell[7534, 273, 182, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7748, 282, 91, 1, 70, "Input"],
Cell[7842, 285, 188, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],
Cell[8042, 294, 151, 4, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8216, 300, 145, 3, 70, "Input"],
Cell[8364, 305, 220, 4, 70, "Message",
  Evaluatable->False],
Cell[8587, 311, 445, 15, 70, "Output",
  Evaluatable->False]
}, Closed]],
Cell[9044, 328, 108, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9175, 332, 80, 1, 70, "Input"],
Cell[9258, 335, 180, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[9470, 344, 80, 1, 70, "Input"],
Cell[9553, 347, 162, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[9747, 356, 80, 1, 70, "Input"],
Cell[9830, 359, 148, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10010, 368, 110, 2, 70, "Input"],
Cell[10123, 372, 543, 17, 70, "Output",
  Evaluatable->False]
}, Closed]],
Cell[10678, 391, 149, 4, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10850, 397, 128, 3, 70, "Input"],
Cell[10981, 402, 154, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],
Cell[11147, 411, 116, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11286, 415, 128, 3, 70, "Input"],
Cell[11417, 420, 176, 8, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[11625, 430, 128, 3, 70, "Input"],
Cell[11756, 435, 163, 7, 70, "Output",
  Evaluatable->False]
}, Closed]],
Cell[11931, 444, 116, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12070, 448, 128, 3, 70, "Input"],
Cell[12201, 453, 167, 8, 70, "Output",
  Evaluatable->False]
}, Closed]],
Cell[12380, 463, 116, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12519, 467, 129, 3, 70, "Input"],
Cell[12651, 472, 188, 8, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[12871, 482, 129, 3, 70, "Input"],
Cell[13003, 487, 220, 10, 70, "Output",
  Evaluatable->False]
}, Closed]],
Cell[13235, 499, 172, 4, 70, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[13439, 505, 104, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13566, 509, 109, 2, 70, "Input"],
Cell[13678, 513, 695, 22, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14414, 537, 105, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14542, 541, 66, 1, 70, "Input"],
Cell[14611, 544, 360, 13, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15012, 559, 92, 2, 70, "Section",
  Evaluatable->False],
Cell[15107, 563, 196, 4, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
